/*
	File:		ConfigQD.h

	Contains:	Public configuration switches.  This file contains
				two basic elements.  The first is a large selector
				which examines the state of all external build flags
				and determines the environment we are compiling for.
				The second is whatever QD-specific switches are required
				to configure the imaging system's external interface.

				Any internal configuration changes are controlled by
				a different file, PrivateConfigQD.h.

				All Quickdraw configuration flags will be of the form
						QD_ConfigSwitchName

	Copyright:	 1993-1996 by Apple Computer, Inc., all rights reserved.

	Derived from v10 internal.

*/



#ifndef __CONFIGQD_H
#define __CONFIGQD_H

#ifndef __CONFIGGLOBAL_H
#include "ConfigGlobal.h"
#endif


//----- Public configuration adjustments -----

	#ifdef __cplusplus
		#define QD_CPlusPlus
	#endif

	#define QD_SupportUnicode

	#ifdef forVirtualNewt
		#define QD_IncludeRenameFile
	#endif

	#define QD_FontRefsFromFrames

	#if ( defined(hasRunt) && !defined(forLindy) && !defined(forSenior) )
		#define QD_HasSoftwareContrastControl
	#endif

#endif
